#!/bin/sh

MASTER_PAGE_ACCOUNTS_MNGT_RESULT_MSG=""
MASTER_PAGE_ACCOUNTS_MNGT_RESULT_OK=0
MASTER_PAGE_ACCOUNTS_MNGT_RESULT_ERROR=1

MASTER_PAGE_ACCOUNTS_MNGT_RESULT_CODE=${MASTER_PAGE_ACCOUNTS_MNGT_RESULT_ERROR}
MASTER_PAGE_ACCOUNTS_MNGT_RESULT_ROLLING=0

master_page_accounts_mngt() {
        dprint "DEBUG" "===== Account management ====="		
	local menu_list="\"${MASTER_PAGE_ACCOUNTS_MNGT_ITEM_1}\" \"\""
	
	##################################################
	# get name_list of all accounts
	##################################################
	local name_list
	name_list=`cat /etc/passwd | awk '{FS=":"} $7 == "/opt/TrendMicro/Pixiebob/textUI/admin_shell" {print "(" $3 "," "\""  $1 "\"" ")";}'`
	
	# no cluster is found
	if [ "$?" != "0" ]; then
		name_list=
	else
		local first
		local cmd
		first=1
		cmd=""

		for item in $name_list
		do
			if [ $first == 1 ]; then
				first=0
				cmd=`echo "[";echo $item`
			else
				cmd=`echo $cmd;echo ",";echo $item`
			fi
		done

		cmd=`echo $cmd;echo "]"`

		name_list=`python -c "a=$cmd;a.sort();b=[item[1] for item in a];print(' '.join(b))"`
	fi

	#debug_print $0 $LINENO "[Account Management] accounts list: $name_list"
	
	##################################################
	# composing name_list to display on menu
	##################################################
	for name in $name_list
	do
        menu_list="$menu_list \"$name\" \"\""
	done
	
	##################################################
	# display menu - cluster setting
	##################################################
	tp_menu_ok_cancel \
		"${MASTER_PAGE_ACCOUNTS_MNGT_TITLE}" \
		"${MASTER_PAGE_ACCOUNTS_MNGT_TEXT}" \
		"${MASTER_PAGE_ACCOUNTS_MNGT_OK_LABEL}" \
		"${MASTER_PAGE_ACCOUNTS_MNGT_CANCEL_LABEL}" \
		"$menu_list"
		
	# if user choose CANCEL or ESC, roll back to main setting page
	if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
		MASTER_PAGE_ACCOUNTS_MNGT_RESULT_CODE=$MASTER_PAGE_ACCOUNTS_MNGT_RESULT_OK
		MASTER_PAGE_ACCOUNTS_MNGT_RESULT_ROLLING=-1
		return
	fi
	#debug_print $0 $LINENO "[Account Management] user choose: $TP_MENU_OK_CANCEL_RESULT_SELECT"
	
	##################################################
	# redirect page
	##################################################
	case "${TP_MENU_OK_CANCEL_RESULT_SELECT}" in
		"${MASTER_PAGE_ACCOUNTS_MNGT_ITEM_1}") 
                        dprint "DEBUG" "Add new account"
			new_account_pages_array="
			master_page_new_account_name
			master_page_ms_new_password
			"
			pages_roller "${new_account_pages_array}"
			;;
		*)                        
			account_to_be_modified=${TP_MENU_OK_CANCEL_RESULT_SELECT}
                        dprint "DEBUG" "Modify account:${account_to_be_modified}"
			master_page_account_conf

			#local whoami=`whoami`
			#if [ "${whoami}" == "${TP_MENU_OK_CANCEL_RESULT_SELECT}" ] || [ "${whoami}" == "root" ]; then
			#	account_to_be_modified=${TP_MENU_OK_CANCEL_RESULT_SELECT}
			#	master_page_account_conf
			#else
			#	local msg=`printf "${MASTER_PAGE_ACCOUNTS_MNGT_PERMISSION_DENY}" "${TP_MENU_OK_CANCEL_RESULT_SELECT}" "${whoami}"`
			#	dialog --msgbox "${msg}" "${box_height}" "${box_width}"
			#fi
			
			;;
	esac
	
        dprint "DEBUG" "===== End account management ====="
	MASTER_PAGE_ACCOUNTS_MNGT_RESULT_CODE=$MASTER_PAGE_ACCOUNTS_MNGT_RESULT_OK
	MASTER_PAGE_ACCOUNTS_MNGT_RESULT_ROLLING=0
}
